/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb;

import com.helger.commons.cache.Cache;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.log.ConditionalLogger;
import com.helger.commons.log.IHasConditionalLogger;
import com.helger.commons.state.EChange;
import com.helger.jaxb.JAXBContextCacheKey;
import jakarta.xml.bind.JAXBContext;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class JAXBContextCache
extends Cache<JAXBContextCacheKey, JAXBContext>
implements IHasConditionalLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(JAXBContextCache.class);
    private static final ConditionalLogger CONDLOG = new ConditionalLogger(LOGGER, false);
    private static boolean s_bDefaultInstantiated = false;

    public static boolean isSilentMode() {
        return CONDLOG.isDisabled();
    }

    public static boolean setSilentMode(boolean bl) {
        return !CONDLOG.setEnabled(!bl);
    }

    private JAXBContextCache() {
        super(jAXBContextCacheKey -> jAXBContextCacheKey.createJAXBContext(CONDLOG), 500, JAXBContextCache.class.getName());
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static JAXBContextCache getInstance() {
        JAXBContextCache jAXBContextCache = SingletonHolder.INSTANCE;
        s_bDefaultInstantiated = true;
        return jAXBContextCache;
    }

    @Override
    @Nullable
    @Deprecated(forRemoval=true, since="11.0.4")
    public JAXBContext getFromCache(@Nonnull Package package_) {
        return (JAXBContext)this.getFromCache(JAXBContextCacheKey.createForPackage(package_));
    }

    @Nullable
    @Deprecated(forRemoval=true, since="11.0.4")
    public JAXBContext getFromCache(@Nonnull Package package_, @Nullable ClassLoader classLoader) {
        return (JAXBContext)this.getFromCache(JAXBContextCacheKey.createForPackage(package_, classLoader));
    }

    @Override
    @Nullable
    @Deprecated(forRemoval=true, since="11.0.4")
    public JAXBContext getFromCache(@Nonnull Class<?> clazz) {
        return (JAXBContext)this.getFromCache(JAXBContextCacheKey.createForClass(clazz));
    }

    @Nullable
    @Deprecated(forRemoval=true, since="11.0.4")
    public JAXBContext getFromCache(@Nonnull Class<?> clazz, @Nullable ClassLoader classLoader) {
        return (JAXBContext)this.getFromCache(JAXBContextCacheKey.createForClass(clazz, classLoader));
    }

    @Override
    @Nullable
    @Deprecated(forRemoval=true, since="11.0.4")
    public JAXBContext getFromCache(@Nonnull ICommonsList<Class<?>> iCommonsList) {
        return (JAXBContext)this.getFromCache(JAXBContextCacheKey.createForClasses(iCommonsList));
    }

    @Nullable
    @Deprecated(forRemoval=true, since="11.0.4")
    public JAXBContext getFromCache(@Nonnull ICommonsList<Class<?>> iCommonsList, @Nullable Map<String, ?> map) {
        return (JAXBContext)this.getFromCache(JAXBContextCacheKey.createForClasses(iCommonsList, map));
    }

    @Override
    @Nonnull
    @Deprecated(forRemoval=true, since="11.0.4")
    public EChange removeFromCache(@Nonnull Package package_) {
        return this.removeFromCache(JAXBContextCacheKey.createForPackage(package_));
    }

    @Nonnull
    @Deprecated(forRemoval=true, since="11.0.4")
    public EChange removeFromCache(@Nonnull Package package_, @Nullable ClassLoader classLoader) {
        return this.removeFromCache(JAXBContextCacheKey.createForPackage(package_, classLoader));
    }

    @Override
    @Nonnull
    @Deprecated(forRemoval=true, since="11.0.4")
    public EChange removeFromCache(@Nonnull ICommonsList<Class<?>> iCommonsList) {
        return this.removeFromCache(JAXBContextCacheKey.createForClasses(iCommonsList));
    }

    @Nonnull
    @Deprecated(forRemoval=true, since="11.0.4")
    public EChange removeFromCache(@Nonnull ICommonsList<Class<?>> iCommonsList, @Nullable Map<String, ?> map) {
        return this.removeFromCache(JAXBContextCacheKey.createForClasses(iCommonsList, map));
    }

    private static final class SingletonHolder {
        static final JAXBContextCache INSTANCE = new JAXBContextCache();

        private SingletonHolder() {
        }
    }
}

