/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.validation;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.error.IError;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.error.list.IErrorList;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.jaxb.validation.AbstractValidationEventHandler;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class CollectingValidationEventHandler
extends AbstractValidationEventHandler {
    protected final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ErrorList m_aErrors = new ErrorList();

    @Override
    protected void onEvent(@Nonnull IError iError) {
        this.m_aRWLock.writeLockedBoolean(() -> this.m_aErrors.add(iError));
    }

    @Nonnull
    @ReturnsMutableCopy
    public IErrorList getErrorList() {
        return this.m_aRWLock.readLockedGet(this.m_aErrors::getClone);
    }

    public void forEachResourceError(@Nonnull Consumer<? super IError> consumer) {
        ValueEnforcer.notNull(consumer, "Consumer");
        this.m_aRWLock.readLocked(() -> this.m_aErrors.forEach(consumer));
    }

    @Nonnull
    public EChange clearResourceErrors() {
        return this.m_aRWLock.writeLockedGet(this.m_aErrors::removeAll);
    }

    @Override
    public String toString() {
        return this.m_aRWLock.readLockedGet(() -> ToStringGenerator.getDerived(super.toString()).append("Errors", this.m_aErrors).getToString());
    }
}

