/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom.convert;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.typeconvert.TypeConverter;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import com.helger.xml.microdom.convert.StringMicroTypeConverter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class StringBasedMicroTypeConverter<T>
implements IMicroTypeConverter<T> {
    private final Class<T> m_aNativeClass;

    public StringBasedMicroTypeConverter(@Nonnull Class<T> clazz) {
        ValueEnforcer.notNull(clazz, "NativeClass");
        this.m_aNativeClass = clazz;
    }

    @Override
    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull T t, @Nullable String string, @Nonnull @Nonempty String string2) {
        String string3 = TypeConverter.convert(t, String.class);
        return StringMicroTypeConverter.getInstance().convertToMicroElement(string3, string, string2);
    }

    @Override
    @Nonnull
    public T convertToNative(@Nonnull IMicroElement iMicroElement) {
        String string = StringMicroTypeConverter.getInstance().convertToNative(iMicroElement);
        return TypeConverter.convert(string, this.m_aNativeClass);
    }
}

