/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.transform;

import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.transform.stream.StreamSource;

@NotThreadSafe
public class CachingTransformStreamSource
extends StreamSource {
    public CachingTransformStreamSource(@Nonnull IReadableResource iReadableResource) {
        this(iReadableResource.getInputStream(), iReadableResource.getResourceID());
    }

    public CachingTransformStreamSource(@Nonnull IHasInputStream iHasInputStream) {
        this(iHasInputStream, null);
    }

    public CachingTransformStreamSource(@Nonnull IHasInputStream iHasInputStream, @Nullable String string) {
        this(iHasInputStream.getInputStream(), string);
    }

    public CachingTransformStreamSource(@Nullable @WillClose InputStream inputStream) {
        this(inputStream, null);
    }

    public CachingTransformStreamSource(@Nullable @WillClose InputStream inputStream, @Nullable String string) {
        super(inputStream == null ? null : new NonBlockingByteArrayInputStream(StreamHelper.getAllBytes(inputStream)), string);
    }

    public String toString() {
        return new ToStringGenerator(this).append("SystemID", this.getSystemId()).getToString();
    }
}

