/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.transform;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.error.IError;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.log.LogHelper;
import com.helger.xml.transform.AbstractTransformErrorListener;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class LoggingTransformErrorListener
extends AbstractTransformErrorListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingTransformErrorListener.class);
    private final Locale m_aDisplayLocale;

    public LoggingTransformErrorListener(@Nonnull Locale locale) {
        this.m_aDisplayLocale = ValueEnforcer.notNull(locale, "DisplayLocale");
    }

    @Nonnull
    public Locale getDisplayLocale() {
        return this.m_aDisplayLocale;
    }

    @Override
    protected void internalLog(@Nonnull IError iError) {
        IErrorLevel iErrorLevel = iError.getErrorLevel();
        String string = iError.getAsString(this.m_aDisplayLocale);
        LogHelper.log(LOGGER, iErrorLevel, string);
    }
}

