/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.util.mime;

import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.mime.MimeTypeParser;
import com.helger.commons.mime.MimeTypeParserException;
import com.helger.commons.string.StringHelper;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import com.helger.xml.microdom.util.MicroHelper;
import com.helger.xml.util.mime.MimeTypeInfo;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class MimeTypeInfoMicroTypeConverter
implements IMicroTypeConverter<MimeTypeInfo> {
    private static final String ELEMENT_MIMETYPE = "mime-type";
    private static final String ELEMENT_COMMENT = "comment";
    private static final String ELEMENT_PARENT_TYPE = "parent-type";
    private static final String ELEMENT_GLOB = "glob";
    private static final String ELEMENT_EXTENSION = "extension";
    private static final String ATTR_SOURCE = "source";

    @Override
    @Nullable
    public IMicroElement convertToMicroElement(@Nonnull MimeTypeInfo mimeTypeInfo, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        for (MimeTypeInfo.MimeTypeWithSource object : mimeTypeInfo.getAllMimeTypesWithSource()) {
            ((IMicroElement)microElement.appendElement(string, ELEMENT_MIMETYPE).setAttribute(ATTR_SOURCE, object.getSource())).appendText(object.getMimeTypeAsString());
        }
        if (mimeTypeInfo.hasComment()) {
            microElement.appendElement(string, ELEMENT_COMMENT).appendText(mimeTypeInfo.getComment());
        }
        for (String string3 : mimeTypeInfo.getAllParentTypes()) {
            microElement.appendElement(string, ELEMENT_PARENT_TYPE).appendText(string3);
        }
        for (String string4 : mimeTypeInfo.getAllGlobs()) {
            microElement.appendElement(string, ELEMENT_GLOB).appendText(string4);
        }
        for (MimeTypeInfo.ExtensionWithSource extensionWithSource : mimeTypeInfo.getAllExtensionsWithSource()) {
            ((IMicroElement)microElement.appendElement(string, ELEMENT_EXTENSION).setAttribute(ATTR_SOURCE, extensionWithSource.getSource())).appendText(extensionWithSource.getExtension());
        }
        microElement.setAttribute(ATTR_SOURCE, mimeTypeInfo.getSource());
        return microElement;
    }

    @Override
    @Nullable
    public MimeTypeInfo convertToNative(@Nonnull IMicroElement iMicroElement) {
        CommonsLinkedHashSet<String> mimeTypeParserException;
        CommonsLinkedHashSet<MimeTypeInfo.MimeTypeWithSource> commonsLinkedHashSet2 = new CommonsLinkedHashSet<MimeTypeInfo.MimeTypeWithSource>();
        for (IMicroElement iCloneable2 : iMicroElement.getAllChildElements(ELEMENT_MIMETYPE)) {
            try {
                mimeTypeParserException = MimeTypeParser.parseMimeType(iCloneable2.getTextContentTrimmed());
                String string = iCloneable2.getAttributeValue(ATTR_SOURCE);
                commonsLinkedHashSet2.add(new MimeTypeInfo.MimeTypeWithSource((IMimeType)((Object)mimeTypeParserException), string));
            }
            catch (MimeTypeParserException mimeTypeParserException2) {
                throw new IllegalStateException("Failed to parse MIME type", mimeTypeParserException2);
            }
        }
        String string = MicroHelper.getChildTextContent(iMicroElement, ELEMENT_COMMENT);
        CommonsLinkedHashSet<String> commonsLinkedHashSet = new CommonsLinkedHashSet<String>();
        for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements(ELEMENT_PARENT_TYPE)) {
            commonsLinkedHashSet.add(iMicroElement2.getTextContentTrimmed());
        }
        mimeTypeParserException = new CommonsLinkedHashSet<String>();
        for (IMicroElement iMicroElement3 : iMicroElement.getAllChildElements(ELEMENT_GLOB)) {
            mimeTypeParserException.add(iMicroElement3.getTextContentTrimmed());
        }
        CommonsLinkedHashSet<MimeTypeInfo.ExtensionWithSource> commonsLinkedHashSet3 = new CommonsLinkedHashSet<MimeTypeInfo.ExtensionWithSource>();
        for (IMicroElement iMicroElement4 : iMicroElement.getAllChildElements(ELEMENT_EXTENSION)) {
            String string2 = StringHelper.getNotNull(iMicroElement4.getTextContentTrimmed());
            String string3 = iMicroElement4.getAttributeValue(ATTR_SOURCE);
            commonsLinkedHashSet3.add(new MimeTypeInfo.ExtensionWithSource(string2, string3));
        }
        String string4 = iMicroElement.getAttributeValue(ATTR_SOURCE);
        return new MimeTypeInfo(commonsLinkedHashSet2, string, commonsLinkedHashSet, mimeTypeParserException, commonsLinkedHashSet3, string4);
    }
}

