/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontFactory;
import org.apache.pdfbox.pdmodel.font.PDType3CharProc;
import org.apache.pdfbox.pdmodel.font.PDType3Font;
import org.apache.pdfbox.pdmodel.font.encoding.Encoding;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightPath;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.content.ContentStreamException;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.font.FontValidator;
import org.apache.pdfbox.preflight.font.container.FontContainer;
import org.apache.pdfbox.preflight.font.container.Type3Container;
import org.apache.pdfbox.preflight.font.util.GlyphException;
import org.apache.pdfbox.preflight.font.util.PreflightType3Stream;
import org.apache.pdfbox.preflight.utils.ContextHelper;

public class Type3FontValidator
extends FontValidator<Type3Container> {
    protected final PDType3Font font;
    protected final COSDictionary fontDictionary;

    public Type3FontValidator(PreflightContext context, PDType3Font font) {
        super(context, font.getCOSObject(), new Type3Container(font));
        this.fontDictionary = font.getCOSObject();
        this.font = font;
    }

    @Override
    public void validate() throws ValidationException {
        this.checkMandatoryField();
        this.checkFontBBox();
        this.checkFontMatrix();
        this.checkEncoding();
        this.checkResources();
        this.checkCharProcsAndMetrics();
        this.checkToUnicode();
    }

    protected void checkMandatoryField() {
        boolean areFieldsPResent = this.fontDictionary.containsKey(COSName.FONT_BBOX);
        areFieldsPResent &= this.fontDictionary.containsKey(COSName.FONT_MATRIX);
        areFieldsPResent &= this.fontDictionary.containsKey(COSName.CHAR_PROCS);
        areFieldsPResent &= this.fontDictionary.containsKey(COSName.ENCODING);
        areFieldsPResent &= this.fontDictionary.containsKey(COSName.FIRST_CHAR);
        areFieldsPResent &= this.fontDictionary.containsKey(COSName.LAST_CHAR);
        if (!(areFieldsPResent &= this.fontDictionary.containsKey(COSName.WIDTHS))) {
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", this.font.getName() + ": Some required fields are missing from the Font dictionary."));
        }
    }

    private void checkFontBBox() {
        COSBase fontBBox = this.fontDictionary.getDictionaryObject(COSName.FONT_BBOX);
        if (!(fontBBox instanceof COSArray)) {
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", this.font.getName() + ": The FontBBox element isn't an array"));
            return;
        }
        COSArray bbox = (COSArray)fontBBox;
        if (bbox.size() != 4) {
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", this.font.getName() + ": The FontBBox element is invalid"));
            return;
        }
        for (int i = 0; i < 4; ++i) {
            COSBase elt = bbox.get(i);
            if (elt instanceof COSFloat || elt instanceof COSInteger) continue;
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", this.font.getName() + ": An element of FontBBox isn't a number"));
            return;
        }
    }

    private void checkFontMatrix() {
        COSBase fontMatrix = this.fontDictionary.getDictionaryObject(COSName.FONT_MATRIX);
        if (!(fontMatrix instanceof COSArray)) {
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", this.font.getName() + ": The FontMatrix element isn't an array"));
            return;
        }
        COSArray matrix = (COSArray)fontMatrix;
        if (matrix.size() != 6) {
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", this.font.getName() + ": The FontMatrix element is invalid"));
            return;
        }
        for (int i = 0; i < 6; ++i) {
            COSBase elt = matrix.get(i);
            if (elt instanceof COSFloat || elt instanceof COSInteger) continue;
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", this.font.getName() + ": An element of FontMatrix isn't a number"));
            return;
        }
    }

    @Override
    protected void checkEncoding() {
        COSBase fontEncoding = this.fontDictionary.getDictionaryObject(COSName.ENCODING);
        if (fontEncoding instanceof COSName) {
            this.checkEncodingAsString(((COSName)fontEncoding).getName());
        } else if (fontEncoding instanceof COSDictionary) {
            this.checkEncodingAsDictionary(this.fontDictionary);
        } else {
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.2.4", this.font.getName() + ": The Encoding entry doesn't have the right type"));
        }
    }

    private void checkEncodingAsString(String enc) {
        Encoding encodingInstance = Encoding.getInstance(COSName.getPDFName(enc));
        if (encodingInstance == null) {
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.2.4", "The encoding '" + enc + "' doesn't exist"));
        }
    }

    private void checkEncodingAsDictionary(COSDictionary encodingDictionary) {
        COSBase diff;
        if (encodingDictionary.containsKey(COSName.BASE_ENCODING)) {
            this.checkEncodingAsString(encodingDictionary.getString(COSName.BASE_ENCODING));
        }
        if ((diff = encodingDictionary.getDictionaryObject(COSName.DIFFERENCES)) != null) {
            if (!(diff instanceof COSArray)) {
                ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.2.4", "The differences element of the encoding dictionary isn't an array"));
                return;
            }
            COSArray diffArray = (COSArray)diff;
            for (int i = 0; i < diffArray.size(); ++i) {
                COSBase item = diffArray.get(i);
                if (item instanceof COSInteger || item instanceof COSName) continue;
                ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.2.4", "Differences Array should contain COSInt or COSName, no other type"));
                return;
            }
        }
    }

    private void checkCharProcsAndMetrics() {
        List<Float> widths = this.getWidths(this.font);
        if (widths == null || widths.isEmpty()) {
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", this.font.getName() + ": The Widths array is unreachable"));
            return;
        }
        COSDictionary charProcs = this.fontDictionary.getCOSDictionary(COSName.CHAR_PROCS);
        if (charProcs == null) {
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", this.font.getName() + ": The CharProcs element isn't a dictionary"));
            return;
        }
        int fc = this.font.getCOSObject().getInt(COSName.FIRST_CHAR, -1);
        int lc = this.font.getCOSObject().getInt(COSName.LAST_CHAR, -1);
        int expectedLength = lc - fc + 1;
        if (widths.size() != expectedLength) {
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", this.font.getName() + ": The length of Widths array is invalid. Expected : \"" + expectedLength + "\" Current : \"" + widths.size() + "\""));
            return;
        }
        for (int i = 0; i < expectedLength; ++i) {
            int code = fc + i;
            float width = widths.get(i).floatValue();
            PDType3CharProc charProc = this.getCharProc(code);
            if (charProc == null) continue;
            try {
                float fontProgramWidth = this.getWidthFromCharProc(charProc);
                if (Math.abs(width - fontProgramWidth) < 0.001f) {
                    ((Type3Container)this.fontContainer).markAsValid(code);
                    continue;
                }
                GlyphException glyphEx = new GlyphException("3.1.6", code, this.font.getName() + ": The character with CID " + code + " should have a width equals to " + width + ", but has " + fontProgramWidth);
                ((Type3Container)this.fontContainer).markAsInvalid(code, glyphEx);
                continue;
            }
            catch (ContentStreamException e) {
                this.context.addValidationError(new ValidationResult.ValidationError(e.getErrorCode(), e.getMessage(), e));
                return;
            }
            catch (IOException e) {
                ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.2.4", this.font.getName() + ": The CharProcs references an element which can't be read", e));
                return;
            }
        }
    }

    public List<Float> getWidths(PDFont font) {
        COSArray array = (COSArray)font.getCOSObject().getDictionaryObject(COSName.WIDTHS);
        if (array != null) {
            return array.toCOSNumberFloatList();
        }
        return Collections.emptyList();
    }

    private PDType3CharProc getCharProc(int code) {
        PDType3CharProc charProc = this.font.getCharProc(code);
        if (charProc == null) {
            GlyphException glyphEx = new GlyphException("3.1.6", code, this.font.getName() + ": The CharProcs \"" + this.font.getEncoding().getName(code) + "\" doesn't exist");
            ((Type3Container)this.fontContainer).markAsInvalid(code, glyphEx);
        }
        return charProc;
    }

    private float getWidthFromCharProc(PDType3CharProc charProc) throws IOException {
        PreflightPath vPath = this.context.getValidationPath();
        PreflightType3Stream parser = new PreflightType3Stream(this.context, vPath.getClosestPathElement(PDPage.class), charProc);
        parser.showType3Character(charProc);
        return parser.getWidth();
    }

    private void checkResources() throws ValidationException {
        COSBase resources = this.fontDictionary.getDictionaryObject(COSName.RESOURCES);
        if (resources != null) {
            if (!(resources instanceof COSDictionary)) {
                ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", this.font.getName() + ": The Resources element isn't a dictionary"));
                return;
            }
            COSDictionary dictionary = (COSDictionary)resources;
            ContextHelper.validateElement(this.context, new PDResources(dictionary), "resources-process");
            COSDictionary dicFonts = dictionary.getCOSDictionary(COSName.FONT);
            if (dicFonts != null) {
                Set<COSName> keyList = dicFonts.keySet();
                for (COSName key : keyList) {
                    COSDictionary xObjFont = dicFonts.getCOSDictionary(key);
                    try {
                        PDFont aFont = PDFontFactory.createFont(xObjFont);
                        FontContainer<?> aContainer = this.context.getFontContainer(aFont.getCOSObject());
                        if (aContainer.isValid()) continue;
                        ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.2.4", this.font.getName() + ": The Resources dictionary of type 3 font contains invalid font"));
                    }
                    catch (IOException e) {
                        this.context.addValidationError(new ValidationResult.ValidationError("3.2", this.font.getName() + ": Unable to valid the Type3 : " + e.getMessage(), e));
                    }
                }
            }
        }
    }
}

