/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import java.math.BigDecimal;
import java.util.HashMap;
import org.mustangproject.ZUGFeRD.IDesignatedProductClassification;
import org.mustangproject.ZUGFeRD.IZUGFeRDAllowanceCharge;

public interface IZUGFeRDExportableProduct {
    public String getUnit();

    public String getName();

    public String getDescription();

    default public String getSellerAssignedID() {
        return null;
    }

    default public String getBuyerAssignedID() {
        return null;
    }

    public BigDecimal getVATPercent();

    default public boolean isIntraCommunitySupply() {
        return false;
    }

    default public boolean isReverseCharge() {
        return false;
    }

    default public String getTaxCategoryCode() {
        if (this.isIntraCommunitySupply()) {
            return "K";
        }
        if (this.isReverseCharge()) {
            return "AE";
        }
        if (this.getVATPercent() == null || this.getVATPercent().compareTo(BigDecimal.ZERO) == 0) {
            return "Z";
        }
        return "S";
    }

    default public String getGlobalID() {
        return null;
    }

    default public String getGlobalIDScheme() {
        return null;
    }

    default public String getTaxExemptionReason() {
        if (this.isIntraCommunitySupply()) {
            return "Intra-community supply";
        }
        if (this.isReverseCharge()) {
            return "Reverse Charge";
        }
        return null;
    }

    default public String getTaxExemptionReasonCode() {
        return null;
    }

    default public String getCountryOfOrigin() {
        return null;
    }

    default public HashMap<String, String> getAttributes() {
        return null;
    }

    default public IZUGFeRDAllowanceCharge[] getAllowances() {
        return null;
    }

    default public IZUGFeRDAllowanceCharge[] getCharges() {
        return null;
    }

    default public IDesignatedProductClassification[] getClassifications() {
        return null;
    }
}

