/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.apache.fop.apps.io.ResourceResolverFactory;
import org.apache.fop.configuration.ConfigurationException;
import org.apache.fop.configuration.DefaultConfiguration;
import org.apache.fop.configuration.DefaultConfigurationBuilder;
import org.mustangproject.ClasspathResolverURIAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationLogVisualizer {
    static final ClassLoader CLASS_LOADER = ValidationLogVisualizer.class.getClassLoader();
    private static final String RESOURCE_PATH = "";
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidationLogVisualizer.class);
    private TransformerFactory mFactory = new TransformerFactoryImpl();
    private Templates mXsltPDFTemplate = null;

    public ValidationLogVisualizer() {
        this.mFactory.setURIResolver(new ClasspathResourceURIResolver());
    }

    protected void applyXSLTToPDF(String xmlContent, OutputStream PDFOutstream) throws TransformerException {
        Transformer transformer = this.mXsltPDFTemplate.newTransformer();
        transformer.transform(new StreamSource(new StringReader(xmlContent)), new StreamResult(PDFOutstream));
    }

    protected String toFOP(String xmlContent) throws TransformerException {
        try {
            if (this.mXsltPDFTemplate == null) {
                this.mXsltPDFTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/result-pdf.xsl")));
            }
        }
        catch (TransformerConfigurationException ex) {
            LOGGER.error("Failed to init XSLT templates", ex);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.applyXSLTToPDF(xmlContent, baos);
        }
        catch (Exception e1) {
            LOGGER.error("Failed to create PDF", e1);
        }
        return baos.toString(StandardCharsets.UTF_8);
    }

    public byte[] createPDFBytes(String xmlLogfileContent) {
        String result = null;
        try {
            result = this.toFOP(xmlLogfileContent);
        }
        catch (TransformerException e) {
            LOGGER.error("Failed to apply FOP", e);
        }
        DefaultConfigurationBuilder cfgBuilder = new DefaultConfigurationBuilder();
        DefaultConfiguration cfg = null;
        try {
            cfg = cfgBuilder.build(CLASS_LOADER.getResourceAsStream("fop-config.xconf"));
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        FopFactoryBuilder builder = new FopFactoryBuilder(new File(".").toURI(), new ClasspathResolverURIAdapter()).setConfiguration(cfg);
        FopFactory fopFactory = builder.build();
        fopFactory.getFontManager().setResourceResolver(ResourceResolverFactory.createInternalResourceResolver(new File(".").toURI(), new ClasspathResolverURIAdapter()));
        FOUserAgent userAgent = fopFactory.newFOUserAgent();
        userAgent.getRendererOptions().put("pdf-a-mode", "PDF/A-3b");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (BufferedOutputStream out = new BufferedOutputStream(baos);){
            Fop fop = fopFactory.newFop("application/pdf", userAgent, out);
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = factory.newTransformer();
            StreamSource src = new StreamSource(new ByteArrayInputStream(result.getBytes(StandardCharsets.UTF_8)));
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            transformer.transform(src, res);
        }
        catch (IOException | TransformerException | FOPException e) {
            LOGGER.error("Failed to create PDF", e);
        }
        return baos.toByteArray();
    }

    public byte[] toPDF(String xmlLogfileContent) {
        return this.createPDFBytes(xmlLogfileContent);
    }

    public void toPDF(String xmlLogfileContent, String pdfFilename) {
        byte[] pdfData = this.createPDFBytes(xmlLogfileContent);
        try (FileOutputStream fos = new FileOutputStream(pdfFilename);){
            fos.write(pdfData);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write PDF to file", e);
        }
    }

    private static class ClasspathResourceURIResolver
    implements URIResolver {
        ClasspathResourceURIResolver() {
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            return new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/" + href));
        }
    }

    public static enum Language {
        EN,
        FR,
        DE;

    }
}

