/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.validator;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.mustangproject.ZUGFeRD.ZUGFeRDImporter;
import org.mustangproject.util.ByteArraySearcher;
import org.mustangproject.validator.EPart;
import org.mustangproject.validator.ESeverity;
import org.mustangproject.validator.IrrecoverableValidationError;
import org.mustangproject.validator.ValidationContext;
import org.mustangproject.validator.ValidationResultItem;
import org.mustangproject.validator.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.verapdf.features.FeatureExtractorConfig;
import org.verapdf.features.FeatureFactory;
import org.verapdf.gf.foundry.VeraGreenfieldFoundryProvider;
import org.verapdf.metadata.fixer.FixerFactory;
import org.verapdf.metadata.fixer.MetadataFixerConfig;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.validation.validators.ValidatorConfig;
import org.verapdf.pdfa.validation.validators.ValidatorFactory;
import org.verapdf.processor.ItemProcessor;
import org.verapdf.processor.ProcessorConfig;
import org.verapdf.processor.ProcessorFactory;
import org.verapdf.processor.ProcessorResult;
import org.verapdf.processor.TaskType;
import org.verapdf.processor.plugins.PluginsCollectionConfig;
import org.verapdf.processor.reports.ItemDetails;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PDFValidator
extends Validator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PDFValidator.class.getCanonicalName());
    private static final PDFAFlavour[] PDF_A_3_FLAVOURS = new PDFAFlavour[]{PDFAFlavour.PDFA_3_A, PDFAFlavour.PDFA_3_B, PDFAFlavour.PDFA_3_U};
    private String pdfFilename;
    private byte[] fileContents;
    private String pdfReport;
    private ProcessorResult processorResult = null;
    private String Signature;
    private String zfXML = null;
    protected boolean autoload = true;

    public PDFValidator(ValidationContext ctx) {
        super(ctx);
    }

    protected static boolean stringArrayContains(String[] arr, String targetValue) {
        return Arrays.asList(arr).contains(targetValue);
    }

    @Override
    public void validate() throws IrrecoverableValidationError {
        this.zfXML = null;
        if (!ByteArraySearcher.startsWith(this.fileContents, new byte[]{37, 80, 68, 70})) {
            this.context.addResultItem(new ValidationResultItem(ESeverity.fatal, "Not a PDF file " + this.pdfFilename).setSection(20).setPart(EPart.pdf));
        }
        long startPDFTime = Calendar.getInstance().getTimeInMillis();
        VeraGreenfieldFoundryProvider.initialise();
        ValidatorConfig validatorConfig = ValidatorFactory.defaultConfig();
        FeatureExtractorConfig featureConfig = FeatureFactory.defaultConfig();
        PluginsCollectionConfig pluginsConfig = PluginsCollectionConfig.defaultConfig();
        MetadataFixerConfig fixerConfig = FixerFactory.defaultConfig();
        EnumSet<TaskType> tasks = EnumSet.noneOf(TaskType.class);
        tasks.add(TaskType.VALIDATE);
        ProcessorConfig processorConfig = ProcessorFactory.fromValues(validatorConfig, featureConfig, pluginsConfig, fixerConfig, tasks);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.fileContents);
        try (ItemProcessor processor = ProcessorFactory.createProcessor(processorConfig);){
            ItemDetails itemDetails = ItemDetails.fromValues(this.pdfFilename);
            ((InputStream)inputStream).mark(Integer.MAX_VALUE);
            this.processorResult = processor.process(itemDetails, inputStream);
            this.pdfReport = this.processorResult.getValidationResult().toString().replaceAll("<\\?xml version=\"1\\.0\" encoding=\"utf-8\"\\?>", "");
            ((InputStream)inputStream).reset();
        }
        catch (Exception excep) {
            this.context.addResultItem(new ValidationResultItem(ESeverity.exception, excep.getMessage()).setSection(7).setPart(EPart.pdf).setStacktrace(excep.getStackTrace().toString()));
        }
        ZUGFeRDImporter zi = new ZUGFeRDImporter();
        zi.doIgnoreCalculationErrors();
        zi.setInputStream(inputStream);
        String xmp = zi.getXMP();
        if (xmp == null || xmp.isEmpty()) {
            this.context.addResultItem(new ValidationResultItem(ESeverity.error, "Invalid XMP Metadata not found").setSection(17).setPart(EPart.pdf));
        } else {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                factory.setXIncludeAware(false);
                DocumentBuilder builder = factory.newDocumentBuilder();
                InputSource is = new InputSource(new StringReader(xmp));
                Document docXMP = builder.parse(is);
                XPathFactory xpathFactory = XPathFactory.newInstance();
                XPath xpath = xpathFactory.newXPath();
                XPathExpression xpr = xpath.compile("//*[local-name()=\"ConformanceLevel\"]|//*[local-name()=\"Description\"]/@ConformanceLevel");
                NodeList nodes = (NodeList)xpr.evaluate(docXMP, XPathConstants.NODESET);
                if (nodes.getLength() == 0) {
                    this.context.addResultItem(new ValidationResultItem(ESeverity.error, "XMP Metadata: ConformanceLevel not found").setSection(11).setPart(EPart.pdf));
                }
                boolean conformanceLevelValid = false;
                for (int i = 0; i < nodes.getLength(); ++i) {
                    String[] valueArray = new String[]{"BASIC WL", "BASIC", "MINIMUM", "EN 16931", "COMFORT", "CIUS", "EXTENDED", "XRECHNUNG"};
                    if (!PDFValidator.stringArrayContains(valueArray, nodes.item(i).getTextContent())) continue;
                    conformanceLevelValid = true;
                }
                if (!conformanceLevelValid) {
                    this.context.addResultItem(new ValidationResultItem(ESeverity.error, "XMP Metadata: ConformanceLevel contains invalid value").setSection(12).setPart(EPart.pdf));
                }
                if ((nodes = (NodeList)(xpr = xpath.compile("//*[local-name()=\"DocumentType\"]|//*[local-name()=\"Description\"]/@DocumentType")).evaluate(docXMP, XPathConstants.NODESET)).getLength() == 0) {
                    this.context.addResultItem(new ValidationResultItem(ESeverity.error, "XMP Metadata: DocumentType not found").setSection(13).setPart(EPart.pdf));
                }
                boolean documentTypeValid = false;
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node item = nodes.item(i);
                    String textContent = item.getTextContent();
                    if (textContent == null || !Set.of("INVOICE", "ORDER", "ORDER_RESPONSE", "ORDER_CHANGE").contains(textContent)) continue;
                    documentTypeValid = true;
                }
                if (!documentTypeValid) {
                    this.context.addResultItem(new ValidationResultItem(ESeverity.error, "XMP Metadata: DocumentType invalid").setSection(14).setPart(EPart.pdf));
                }
                if ((nodes = (NodeList)(xpr = xpath.compile("//*[local-name()=\"DocumentFileName\"]|//*[local-name()=\"Description\"]/@DocumentFileName")).evaluate(docXMP, XPathConstants.NODESET)).getLength() == 0) {
                    this.context.addResultItem(new ValidationResultItem(ESeverity.error, "XMP Metadata: DocumentFileName not found").setSection(21).setPart(EPart.pdf));
                }
                boolean documentFilenameValid = false;
                for (int i = 0; i < nodes.getLength(); ++i) {
                    String[] valueArray = new String[]{"factur-x.xml", "ZUGFeRD-invoice.xml", "zugferd-invoice.xml", "xrechnung.xml", "order-x.xml"};
                    if (!PDFValidator.stringArrayContains(valueArray, nodes.item(i).getTextContent())) continue;
                    documentFilenameValid = true;
                }
                if (!documentFilenameValid) {
                    if (zi.hasXMLFileAttachment()) {
                        this.context.addResultItem(new ValidationResultItem(ESeverity.notice, "Potentially incorrectly named XML file attachments detected").setSection(17).setPart(EPart.pdf));
                    }
                    this.context.addResultItem(new ValidationResultItem(ESeverity.error, "XMP Metadata: DocumentFileName contains invalid value").setSection(19).setPart(EPart.pdf));
                }
                if ((nodes = (NodeList)(xpr = xpath.compile("//*[local-name()=\"Version\"]|//*[local-name()=\"Description\"]/@Version")).evaluate(docXMP, XPathConstants.NODESET)).getLength() == 0) {
                    this.context.addResultItem(new ValidationResultItem(ESeverity.error, "XMP Metadata: Version not found").setSection(15).setPart(EPart.pdf));
                }
                boolean versionValid = false;
                for (int i = 0; i < nodes.getLength(); ++i) {
                    String[] valueArray = new String[]{"1.0", "1p0", "2p0", "1.2", "2.0", "2.1", "2.2", "2.3", "3.0"};
                    if (!PDFValidator.stringArrayContains(valueArray, nodes.item(i).getTextContent())) continue;
                    versionValid = true;
                }
                if (!versionValid) {
                    this.context.addResultItem(new ValidationResultItem(ESeverity.error, "XMP Metadata: Version contains invalid value").setSection(16).setPart(EPart.pdf));
                }
            }
            catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
                LOGGER.error(e.getMessage(), e);
            }
        }
        this.zfXML = zi.getUTF8();
        byte[] symtraxSignature = "Symtrax".getBytes(StandardCharsets.UTF_8);
        byte[] mustangSignature = "via mustangproject".getBytes(StandardCharsets.UTF_8);
        byte[] facturxpythonSignature = "by Alexis de Lattre".getBytes(StandardCharsets.UTF_8);
        byte[] intarsysSignature = "intarsys ".getBytes(StandardCharsets.UTF_8);
        byte[] konikSignature = "Konik".getBytes(StandardCharsets.UTF_8);
        byte[] pdfMachineSignature = "pdfMachine from Broadgun Software".getBytes(StandardCharsets.UTF_8);
        byte[] ghostscriptSignature = "%%Invocation:".getBytes(StandardCharsets.UTF_8);
        byte[] cibpdfbrewerSignature = "CIB pdf brewer".getBytes(StandardCharsets.UTF_8);
        byte[] lexofficeSignature = "lexoffice".getBytes(StandardCharsets.UTF_8);
        byte[] s2IndustriesSignature = "s2industries.ZUGFeRD.PDF".getBytes(StandardCharsets.UTF_8);
        byte[] factoorSharpSignature = "FactoorSharp".getBytes(StandardCharsets.UTF_8);
        byte[] sevdeskSignature = "sevdesk".getBytes(StandardCharsets.UTF_8);
        if (ByteArraySearcher.contains(this.fileContents, symtraxSignature)) {
            this.Signature = "Symtrax";
        } else if (ByteArraySearcher.contains(this.fileContents, mustangSignature)) {
            this.Signature = "Mustang";
        } else if (ByteArraySearcher.contains(this.fileContents, facturxpythonSignature)) {
            this.Signature = "Factur/X Python";
        } else if (ByteArraySearcher.contains(this.fileContents, intarsysSignature)) {
            this.Signature = "Intarsys";
        } else if (ByteArraySearcher.contains(this.fileContents, konikSignature)) {
            this.Signature = "Konik";
        } else if (ByteArraySearcher.contains(this.fileContents, pdfMachineSignature)) {
            this.Signature = "pdfMachine";
        } else if (ByteArraySearcher.contains(this.fileContents, ghostscriptSignature)) {
            this.Signature = "Ghostscript";
        } else if (ByteArraySearcher.contains(this.fileContents, cibpdfbrewerSignature)) {
            this.Signature = "CIB pdf brewer";
        } else if (ByteArraySearcher.contains(this.fileContents, lexofficeSignature)) {
            this.Signature = "Lexware office";
        } else if (ByteArraySearcher.contains(this.fileContents, s2IndustriesSignature)) {
            this.Signature = "ZUGFeRD.PDF-csharp";
        } else if (ByteArraySearcher.contains(this.fileContents, factoorSharpSignature)) {
            this.Signature = "FactoorSharp";
        } else if (ByteArraySearcher.contains(this.fileContents, sevdeskSignature)) {
            this.Signature = "sevdesk";
        }
        this.context.setSignature(this.Signature);
        HashMap<String, byte[]> additionalData = zi.getAdditionalData();
        for (String filename : additionalData.keySet()) {
            LOGGER.info("validating additionalData {}", (Object)filename);
            this.validateSchema(additionalData.get(filename), "ad/basic/additional_data_base_schema.xsd", 2, EPart.pdf);
        }
        long endTime = Calendar.getInstance().getTimeInMillis();
        if (!this.processorResult.getValidationResult().isCompliant()) {
            this.context.setInvalid();
        }
        PDFAFlavour pdfaFlavourFromValidationResult = this.processorResult.getValidationResult().getPDFAFlavour();
        if (Arrays.stream(PDF_A_3_FLAVOURS).noneMatch(pdfaFlavourFromValidationResult::equals)) {
            this.context.addResultItem(new ValidationResultItem(ESeverity.error, "Not a PDF/A-3").setSection(23).setPart(EPart.pdf));
        }
        this.context.addCustomXML(this.pdfReport + "<info><signature>" + (this.context.getSignature() != null ? this.context.getSignature() : "unknown") + "</signature><duration unit=\"ms\">" + (endTime - startPDFTime) + "</duration></info>");
    }

    @Override
    public void setFilename(String filename) throws IrrecoverableValidationError {
        this.pdfFilename = filename;
        if (this.autoload) {
            try {
                this.fileContents = Files.readAllBytes(Paths.get(this.pdfFilename, new String[0]));
            }
            catch (IOException ex) {
                throw new IrrecoverableValidationError("Could not read file");
            }
        }
    }

    public void setFileContents(byte[] fileContents) {
        this.fileContents = fileContents;
    }

    public void setFilenameAndContents(String filename, byte[] fileContents) {
        this.pdfFilename = filename;
        this.fileContents = fileContents;
    }

    public String getRawXML() {
        return this.zfXML;
    }

    public String getSignature() {
        return this.Signature;
    }
}

