/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cos;

import org.verapdf.cos.COSNumber;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.visitor.ICOSVisitor;
import org.verapdf.cos.visitor.IVisitor;

public class COSInteger
extends COSNumber {
    private long value;

    protected COSInteger(long value) {
        this.value = value;
    }

    @Override
    public COSObjType getType() {
        return COSObjType.COS_INTEGER;
    }

    public static COSObject construct(long initValue) {
        return new COSObject(new COSInteger(initValue));
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitFromInteger(this);
    }

    @Override
    public Object accept(ICOSVisitor visitor) {
        return visitor.visitFromInteger(this);
    }

    @Override
    public Long getInteger() {
        return this.get();
    }

    @Override
    public boolean setInteger(long value) {
        this.set(value);
        return true;
    }

    @Override
    public Double getReal() {
        return this.get();
    }

    @Override
    public boolean setReal(double value) {
        this.set((long)value);
        return true;
    }

    public long get() {
        return this.value;
    }

    public void set(long value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof COSInteger)) {
            return false;
        }
        COSInteger that = (COSInteger)o;
        return this.value == that.value;
    }
}

