/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.gf.objects;

import jakarta.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSObject;
import org.verapdf.features.gf.tools.GFAdapterHelper;
import org.verapdf.features.objects.ColorSpaceFeaturesObjectAdapter;
import org.verapdf.pd.colors.PDCIEDictionaryBased;
import org.verapdf.pd.colors.PDCalGray;
import org.verapdf.pd.colors.PDCalRGB;
import org.verapdf.pd.colors.PDColorSpace;
import org.verapdf.pd.colors.PDDeviceN;
import org.verapdf.pd.colors.PDICCBased;
import org.verapdf.pd.colors.PDIndexed;
import org.verapdf.pd.colors.PDLab;
import org.verapdf.pd.colors.PDSeparation;

public class GFColorSpaceFeaturesObjectAdapter
implements ColorSpaceFeaturesObjectAdapter {
    private static final Logger LOGGER = Logger.getLogger(GFColorSpaceFeaturesObjectAdapter.class.getCanonicalName());
    private final PDColorSpace colorSpace;
    private final String id;
    private final String iccProfileChild;
    private final String colorSpaceChild;
    private String lookup;
    private List<String> errors;

    public GFColorSpaceFeaturesObjectAdapter(PDColorSpace colorSpace, String id, String iccProfileChild, String colorSpaceChild) {
        this.colorSpace = colorSpace;
        this.id = id;
        this.iccProfileChild = iccProfileChild;
        this.colorSpaceChild = colorSpaceChild;
        this.init(colorSpace);
    }

    private void init(PDColorSpace colorSpace) {
        ASAtom colorSpaceType = colorSpace.getType();
        if (ASAtom.INDEXED.equals(colorSpaceType)) {
            PDIndexed index = (PDIndexed)colorSpace;
            try (ASInputStream stream = index.getLookup();){
                byte[] lookupData = GFAdapterHelper.inputStreamToByteArray(stream);
                this.lookup = DatatypeConverter.printHexBinary(lookupData);
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, e.getMessage(), e);
                this.errors = new ArrayList<String>();
                this.errors.add("Problem during converting lookup value to hex string");
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getFamily() {
        if (this.colorSpace == null || this.colorSpace.empty()) {
            return null;
        }
        return GFAdapterHelper.getStringFromASAtom(this.colorSpace.getType());
    }

    @Override
    public String getColorSpaceChild() {
        return this.colorSpaceChild;
    }

    @Override
    public String getICCProfileChild() {
        return this.iccProfileChild;
    }

    @Override
    public double[] getWhitePoint() {
        if (this.colorSpace == null || this.colorSpace.empty()) {
            return null;
        }
        ASAtom colorSpaceType = this.colorSpace.getType();
        if (ASAtom.CALGRAY.equals(colorSpaceType) || ASAtom.CALRGB.equals(colorSpaceType) || ASAtom.LAB.equals(colorSpaceType)) {
            PDCIEDictionaryBased cie = (PDCIEDictionaryBased)this.colorSpace;
            return cie.getWhitePoint();
        }
        return null;
    }

    @Override
    public double[] getBlackPoint() {
        if (this.colorSpace == null || this.colorSpace.empty()) {
            return null;
        }
        ASAtom colorSpaceType = this.colorSpace.getType();
        if (ASAtom.CALGRAY.equals(colorSpaceType) || ASAtom.CALRGB.equals(colorSpaceType) || ASAtom.LAB.equals(colorSpaceType)) {
            PDCIEDictionaryBased cie = (PDCIEDictionaryBased)this.colorSpace;
            return cie.getBlackPoint();
        }
        return null;
    }

    @Override
    public Double getCalGrayGamma() {
        if (this.colorSpace == null || this.colorSpace.empty()) {
            return null;
        }
        ASAtom colorSpaceType = this.colorSpace.getType();
        if (ASAtom.CALGRAY.equals(colorSpaceType)) {
            PDCalGray calGray = (PDCalGray)this.colorSpace;
            return calGray.getGamma();
        }
        return null;
    }

    @Override
    public double[] getCalRGBGamma() {
        if (this.colorSpace == null || this.colorSpace.empty()) {
            return null;
        }
        ASAtom colorSpaceType = this.colorSpace.getType();
        if (ASAtom.CALRGB.equals(colorSpaceType)) {
            PDCalRGB calRGB = (PDCalRGB)this.colorSpace;
            return calRGB.getGamma();
        }
        return null;
    }

    @Override
    public double[] getMatrix() {
        if (this.colorSpace == null || this.colorSpace.empty()) {
            return null;
        }
        ASAtom colorSpaceType = this.colorSpace.getType();
        if (ASAtom.CALRGB.equals(colorSpaceType)) {
            PDCalRGB calRGB = (PDCalRGB)this.colorSpace;
            return calRGB.getMatrix();
        }
        return null;
    }

    @Override
    public double[] getLabRange() {
        ASAtom colorSpaceType = this.colorSpace.getType();
        if (ASAtom.LAB.equals(colorSpaceType)) {
            PDLab lab = (PDLab)this.colorSpace;
            return lab.getRange();
        }
        return null;
    }

    @Override
    public int getNumberOfComponents() {
        if (this.colorSpace == null || this.colorSpace.empty()) {
            return 0;
        }
        ASAtom colorSpaceType = this.colorSpace.getType();
        if (ASAtom.ICCBASED.equals(colorSpaceType)) {
            PDICCBased iccBased = (PDICCBased)this.colorSpace;
            return iccBased.getNumberOfComponents();
        }
        return 0;
    }

    @Override
    public Long getHival() {
        if (this.colorSpace == null || this.colorSpace.empty()) {
            return null;
        }
        ASAtom colorSpaceType = this.colorSpace.getType();
        if (ASAtom.INDEXED.equals(colorSpaceType)) {
            PDIndexed indexed = (PDIndexed)this.colorSpace;
            return indexed.getHival();
        }
        return null;
    }

    @Override
    public String getHexEncodedLookup() {
        return this.lookup;
    }

    @Override
    public String getColorantName() {
        if (this.colorSpace == null || this.colorSpace.empty()) {
            return null;
        }
        ASAtom colorSpaceType = this.colorSpace.getType();
        if (ASAtom.SEPARATION.equals(colorSpaceType)) {
            PDSeparation separation = (PDSeparation)this.colorSpace;
            return GFAdapterHelper.getStringFromCOSObject(separation.getColorantName());
        }
        return null;
    }

    @Override
    public List<String> getColorantNames() {
        if (this.colorSpace == null || this.colorSpace.empty()) {
            return null;
        }
        ASAtom colorSpaceType = this.colorSpace.getType();
        if (ASAtom.DEVICEN.equals(colorSpaceType)) {
            PDDeviceN deviceN = (PDDeviceN)this.colorSpace;
            List<COSObject> names = deviceN.getNames();
            ArrayList<String> res = new ArrayList<String>(names.size());
            for (COSObject name : names) {
                res.add(GFAdapterHelper.getStringFromCOSObject(name));
            }
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isPDFObjectPresent() {
        return this.colorSpace != null && !this.colorSpace.empty();
    }

    @Override
    public List<String> getErrors() {
        return this.errors == null ? Collections.emptyList() : Collections.unmodifiableList(this.errors);
    }
}

