/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.font;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.gf.model.factory.operators.RenderingMode;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.pd.font.GFPDSimpleFont;
import org.verapdf.gf.model.tools.GFIDGenerator;
import org.verapdf.model.operator.Glyph;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.cff.CFFFontProgram;
import org.verapdf.pd.font.cff.CFFType1FontProgram;
import org.verapdf.pd.font.opentype.OpenTypeFontProgram;
import org.verapdf.pd.font.type1.PDType1Font;
import org.verapdf.pd.font.type1.Type1FontProgram;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.tools.StaticResources;

public class GFPDType1Font
extends GFPDSimpleFont
implements org.verapdf.model.pdlayer.PDType1Font {
    private static final Logger LOGGER = Logger.getLogger(GFPDType1Font.class.getCanonicalName());
    public static final String TYPE1_FONT_TYPE = "PDType1Font";
    public static final String NOTDEF_STRING = ".notdef";

    public GFPDType1Font(PDType1Font pdFont, RenderingMode renderingMode) {
        super(pdFont, renderingMode, TYPE1_FONT_TYPE);
        if (pdFont != null) {
            FontProgram program = pdFont.getFontProgram();
            if (program != null) {
                StaticResources.getDocument().getDocument().getResourceHandler().addResource(program.getFontProgramResource());
            }
            if (program != null) {
                try {
                    if (!program.isAttemptedParsing()) {
                        program.parseFont();
                    }
                    this.fontProgramParsed = program.isSuccessfulParsing();
                    this.pdFont.setSuccessfullyParsed(program.isSuccessfulParsing());
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, "Can't parse font program of font " + pdFont.getName(), e);
                    this.fontProgramParsed = false;
                    this.pdFont.setSuccessfullyParsed(false);
                }
            }
        }
    }

    @Override
    public String getCharSet() {
        return this.pdFont.getFontDescriptor().getStringKey(ASAtom.CHAR_SET);
    }

    @Override
    public Boolean getcharSetListsAllGlyphs() {
        block12: {
            Set<String> fontProgramCharSet;
            Set<String> descriptorCharSet;
            block11: {
                if (!this.fontProgramParsed) {
                    return Boolean.FALSE;
                }
                descriptorCharSet = ((PDType1Font)this.pdFont).getDescriptorCharSet();
                if (this.pdFont.getFontProgram() instanceof Type1FontProgram) {
                    fontProgramCharSet = ((Type1FontProgram)this.pdFont.getFontProgram()).getCharSet();
                } else if (this.pdFont.getFontProgram() instanceof CFFFontProgram) {
                    fontProgramCharSet = ((CFFType1FontProgram)((CFFFontProgram)this.pdFont.getFontProgram()).getFont()).getCharSet();
                } else if (this.pdFont.getFontProgram() instanceof OpenTypeFontProgram) {
                    Iterator<String> cff = (CFFFontProgram)((OpenTypeFontProgram)this.pdFont.getFontProgram()).getFont();
                    fontProgramCharSet = ((CFFType1FontProgram)((CFFFontProgram)((Object)cff)).getFont()).getCharSet();
                } else {
                    fontProgramCharSet = new TreeSet<String>();
                }
                if (StaticContainers.getFlavour().getPart() == PDFAFlavour.Specification.ISO_19005_1) break block11;
                if (descriptorCharSet.size() != fontProgramCharSet.size() && descriptorCharSet.size() != fontProgramCharSet.size() - 1) {
                    return Boolean.FALSE;
                }
                for (String glyphName : descriptorCharSet) {
                    if (NOTDEF_STRING.equals(glyphName) || fontProgramCharSet.contains(glyphName)) continue;
                    return Boolean.FALSE;
                }
                for (String glyphName : fontProgramCharSet) {
                    if (NOTDEF_STRING.equals(glyphName) || descriptorCharSet.contains(glyphName)) continue;
                    return Boolean.FALSE;
                }
                break block12;
            }
            Map<String, Glyph> map = StaticContainers.getCachedGlyphs().get(GFIDGenerator.generateID(this.pdFont));
            if (map == null) break block12;
            for (Glyph glyph : map.values()) {
                String glyphName = glyph.getname();
                if (!fontProgramCharSet.contains(glyphName) || descriptorCharSet.contains(glyphName)) continue;
                return false;
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean getisStandard() {
        return ((PDType1Font)this.pdFont).isStandard();
    }
}

