/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.results;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.results.TestAssertion;
import org.verapdf.pdfa.results.ValidationResult;
import org.verapdf.pdfa.validation.profiles.ProfileDetails;
import org.verapdf.pdfa.validation.profiles.Profiles;
import org.verapdf.pdfa.validation.profiles.RuleId;
import org.verapdf.pdfa.validation.profiles.ValidationProfile;
import org.verapdf.processor.reports.enums.JobEndStatus;

@XmlRootElement(name="validationResult")
final class ValidationResultImpl
implements ValidationResult {
    private static final ValidationResultImpl DEFAULT = new ValidationResultImpl();
    @XmlAttribute
    private final PDFAFlavour flavour;
    @XmlElement
    private final ProfileDetails profileDetails;
    @XmlAttribute
    private final int totalAssertions;
    @XmlElementWrapper
    @XmlElement(name="assertion")
    private final List<TestAssertion> assertions;
    @XmlAttribute
    private final boolean isCompliant;
    @XmlAttribute
    private final JobEndStatus jobEndStatus;
    private HashMap<RuleId, Integer> failedChecks = null;
    private final ValidationProfile validationProfile;

    private ValidationResultImpl() {
        this(Profiles.defaultProfile(), Collections.emptyList(), false, JobEndStatus.NORMAL);
    }

    private ValidationResultImpl(ValidationProfile validationProfile, List<TestAssertion> assertions, boolean isCompliant, JobEndStatus endStatus) {
        this(validationProfile, assertions, isCompliant, assertions.size(), endStatus);
    }

    private ValidationResultImpl(ValidationProfile validationProfile, List<TestAssertion> assertions, boolean isCompliant, int totalAssertions, JobEndStatus endStatus) {
        this.flavour = validationProfile.getPDFAFlavour();
        this.assertions = new ArrayList<TestAssertion>(assertions);
        this.isCompliant = isCompliant;
        this.totalAssertions = totalAssertions;
        this.profileDetails = validationProfile.getDetails();
        this.validationProfile = validationProfile;
        this.jobEndStatus = endStatus;
    }

    private ValidationResultImpl(ValidationProfile validationProfile, List<TestAssertion> assertions, HashMap<RuleId, Integer> failedChecks, boolean isCompliant, int totalAssertions, JobEndStatus endStatus) {
        this(validationProfile, assertions, isCompliant, totalAssertions, endStatus);
        this.failedChecks = failedChecks;
    }

    @Override
    public boolean isCompliant() {
        return this.isCompliant;
    }

    @Override
    public PDFAFlavour getPDFAFlavour() {
        return this.flavour;
    }

    @Override
    public ProfileDetails getProfileDetails() {
        return this.profileDetails;
    }

    @Override
    public int getTotalAssertions() {
        return this.totalAssertions;
    }

    @Override
    public List<TestAssertion> getTestAssertions() {
        return Collections.unmodifiableList(this.assertions);
    }

    @Override
    public ValidationProfile getValidationProfile() {
        return this.validationProfile;
    }

    @Override
    public JobEndStatus getJobEndStatus() {
        return this.jobEndStatus;
    }

    @Override
    public HashMap<RuleId, Integer> getFailedChecks() {
        return this.failedChecks;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.assertions == null ? 0 : this.assertions.hashCode());
        result = 31 * result + (this.flavour == null ? 0 : this.flavour.hashCode());
        result = 31 * result + (this.isCompliant ? 1231 : 1237);
        result = 31 * result + (this.jobEndStatus == null ? 0 : this.jobEndStatus.hashCode());
        result = 31 * result + this.totalAssertions;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValidationResult other = (ValidationResult)obj;
        if (!Objects.equals(this.assertions, other.getTestAssertions())) {
            return false;
        }
        if (this.flavour != other.getPDFAFlavour()) {
            return false;
        }
        if (this.isCompliant != other.isCompliant()) {
            return false;
        }
        if (this.jobEndStatus != other.getJobEndStatus()) {
            return false;
        }
        return this.totalAssertions == other.getTotalAssertions();
    }

    public String toString() {
        return "ValidationResult [flavour=" + (Object)((Object)this.flavour) + ", totalAssertions=" + this.totalAssertions + ", assertions=" + this.assertions + ", isCompliant=" + this.isCompliant + "]";
    }

    static ValidationResultImpl defaultInstance() {
        return DEFAULT;
    }

    static ValidationResultImpl fromValues(ValidationProfile validationProfile, List<TestAssertion> assertions, HashMap<RuleId, Integer> failedChecks, boolean isCompliant, int totalChecks, JobEndStatus endStatus) {
        return new ValidationResultImpl(validationProfile, assertions, failedChecks, isCompliant, totalChecks, endStatus);
    }

    static ValidationResultImpl fromValues(ValidationProfile validationProfile, List<TestAssertion> assertions, boolean isCompliant, int totalChecks, JobEndStatus endStatus) {
        return new ValidationResultImpl(validationProfile, assertions, isCompliant, totalChecks, endStatus);
    }

    static ValidationResultImpl fromValidationResult(ValidationResult toConvert) {
        List<TestAssertion> assertions = toConvert.getTestAssertions();
        return ValidationResultImpl.fromValues(toConvert.getValidationProfile(), assertions, toConvert.isCompliant(), toConvert.getTotalAssertions(), toConvert.getJobEndStatus());
    }

    static ValidationResultImpl stripPassedTests(ValidationResult toStrip) {
        List<TestAssertion> assertions = toStrip.getTestAssertions();
        return ValidationResultImpl.fromValues(toStrip.getValidationProfile(), ValidationResultImpl.stripPassedTests(assertions), toStrip.isCompliant(), toStrip.getTotalAssertions(), toStrip.getJobEndStatus());
    }

    static List<TestAssertion> stripPassedTests(List<TestAssertion> toStrip) {
        ArrayList<TestAssertion> strippedList = new ArrayList<TestAssertion>();
        for (TestAssertion test : toStrip) {
            if (test.getStatus() == TestAssertion.Status.PASSED) continue;
            strippedList.add(test);
        }
        return strippedList;
    }

    static class Adapter
    extends XmlAdapter<ValidationResultImpl, ValidationResult> {
        Adapter() {
        }

        @Override
        public ValidationResult unmarshal(ValidationResultImpl validationResultImpl) {
            return validationResultImpl;
        }

        @Override
        public ValidationResultImpl marshal(ValidationResult validationResult) {
            return (ValidationResultImpl)validationResult;
        }
    }
}

